﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Inet.Viewer.Data;
using System.IO;
using System.Threading;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// 
    /// </summary>
    [TestFixture]
    public class TestExportProgress
    {        
        static string[] formats = { "pdf", "html", "ods", "xls", "xml", "svg", "txt", "data", "csv", "ps", "ps2", "ps3", "gif", "jpg", "bmp", "png", "rtf" };

        const string report1 = "http://dell28:9000/?report=repo:%2Fadhoc_root%2F03-blueberry%2F05-blueberry-crosstab-landscape.rpt";
        int[] progress1 = { 16, 123, 7, 13, 9, 203, 14, 1, 1, 733, 102, 794, 160, 137, 263, 227, 281 };

        const string report2 = "http://localhost:9000/?report=C:/Users/michaels/Eigene Dokumente/Reports/MassiveReport3.rpt";        
        int[] progress2 = { 568, 9435, 7, 357, 3404, 4204, 1, 1, 1, 5994, 5995, 6013, 405, 254, 593, 714, 7299 };

        const string report3 = "http://localhost:9000/?report=C:/Users/michaels/Eigene Dokumente/Reports/Test/Export1.rpt";
        int[] progress3 = { 520, 2812, 2511, 2548, 114, 3657, 26, 11, 109, 6029, 6121, 6198, 168, 414, 557, 373, 1091 };
        
        /// <summary>
        /// the progress count by the event
        /// </summary>
        private int progressStatusEvent;
        // to count the amount of event invokes for each ExportProgress separately
        private Dictionary<ExportProgress, int> countProgress = new Dictionary<ExportProgress, int>();
        IRenderData data;
        
        private static string[] GetExportFormats()
        {
            return formats;
        }
        

        /// <summary>
        /// Test for report1
        /// </summary>
        [Test, TestCaseSource("GetExportFormats")]
        public void TestExportReport1(string format)
        {
            TestExportReportCase(format, formats, progress1, report1);
        }

        /* At the moment these test are for local use only    
        /// <summary>
        /// Test for report2
        /// </summary>
        [Test, TestCaseSource("GetExportFormats")]
        public void TestExportReport2(string format)
        {
            TestExportReportCases(format, formats, progress2, report2);
        }

        /// <summary>
        /// Test for report3
        /// </summary>
        [Test, TestCaseSource("GetExportFormats")]
        public void TestExportReport3(string format)
        {
            TestExportReportCases(format, formats, progress3, report3);
        }*/

      

        /// <summary>
        /// To invoke the Tests for this one report 
        /// </summary>       
        public void TestExportReportCase(string format, string[] formats, int[] progress, string report)
        {
            DirectoryInfo directory = new DirectoryInfo("C:\\Windows\\Temp\\exportTest");
            if (!directory.Exists) directory.Create();

            ProgressMode mode = ProgressMode.Steps;
            if (format.Equals("gif") || format.Equals("bmp") || format.Equals("jpg") || format.Equals("png"))
            {
                mode = ProgressMode.Continuous;
            }
            data = new URLRenderData(report);
            int index = Array.IndexOf(formats, format);
            TestExport(format, progress[index], report, mode, directory.FullName);
        }
      
      

        /// <summary>
        ///  Is testing one report with one format
        /// </summary>
        /// <param name="format">the export format</param>
        /// <param name="totalProgress"></param>
        /// <param name="reportUrl">the report that should be exported</param>
        /// <param name="mode"></param>
        /// <param name="directory">the directory the report should be exported to</param>
        public void TestExport(string format, int totalProgress, string reportUrl, ProgressMode mode, string directory)
        {         

            Dictionary<string, string> parameters = new Dictionary<string, string>();
            parameters["export_fmt"] = format;          
            parameters["file"] = directory +"\\export_" + format.ToUpper() + "." + format.ToLower();
            parameters["locale"] = "de-DE";
            ExportProgress expProgress = new ExportProgress(null, data, parameters);

            //progressCountEvent = 0;
            countProgress[expProgress] = 0;
            expProgress.ProgressChanged += new EventHandler(expProgress_ProgressChanged);
            expProgress.StatusChanged += new EventHandler(expProgress_StatusChanged);

            Assert.AreEqual(Progress.ProgressStatus.Initialized, expProgress.Status);
            // start the progress
            expProgress.StartProgress();

            int i= 0;
            // wait until status is COMPLETED
            while (i < 2000 & expProgress.Status != Progress.ProgressStatus.Completed)
            {                
                Thread.Sleep(50);                
                i++;
            }
    
            Assert.AreNotEqual(Progress.ProgressStatus.Error, expProgress.Status, "An exception occured during "+ format.ToUpper() +" export:   " + expProgress.ErrorMessage);                    
            Assert.AreEqual(Progress.ProgressStatus.Completed, expProgress.Status);         
            
            Assert.AreEqual(mode, expProgress.ProgressMode, " The progress mode");         
            // +1 is for the calculcation of the TotalProgress
            int addTotal = 2;           
            int countEvent = countProgress[expProgress];
            if (expProgress.ProgressMode == ProgressMode.Steps)
            {
                // Only for ProgressMode.Steps, for Continuous the progress steps are not shown
                Assert.AreEqual(expProgress.TotalProgress + addTotal, countEvent, " The event should be invoked so many times for (" + format + ")");
            }

            /* Removed as the amount of ProgressCount is different for the formats "png" and "bmp"
            if (expProgress.ProgressMode == ProgressMode.Steps)
            {
                Assert.AreEqual(totalProgress, expProgress.TotalProgress, " The total amount(" + format.ToUpper() + ")");
            }            
            // this part only works properly if the ProgressCount is the same, everytime the report is rendered
            Assert.AreEqual(totalProgress, expProgress.ProgressCount, " The counted progress (" + format.ToUpper() + ")");            
            */

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void expProgress_StatusChanged(object sender, EventArgs e)
        {
            progressStatusEvent++;
        }

        /// <summary>
        /// Receives the ProgressChanged event and add it to the
        /// Dictionary with the ExportProgress as key
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void expProgress_ProgressChanged(object sender, EventArgs e)
        {
            ExportProgress prog = sender as ExportProgress;
            int count = countProgress[prog];
            count++;
            countProgress[prog] = count;            
        }
    }
}
